/**
 * 
 */
package gov.va.med.mhv.usermgmt.test.builder;

import java.io.IOException;
import java.util.List;

import org.apache.commons.lang.StringUtils;

/**
 * @author Rob Proper (Aquilent Inc.)
 *
 */
public final class UserGenerator {

    /**
     * @param args
     */
    public static void main(String[] args) {
        String fileName = getFileName(args);
        if (StringUtils.isBlank(fileName)) {
            System.err.println("Missing filename");
            System.err.println("Usage: " + args[0] + " --file <file-name>");
        }
        UserReader reader = null;
        try {
            reader = new UserReader(fileName);
        } catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        List<User> users= reader.getUsers();
        if (users != null) {
            for (User user: users) {
                System.out.print("Building user '" + user.
                    getUserProfile().getUserName() + "' ... ");
                try {
                    new UserBuilder(user).setUp();
                    System.out.println("done.");
                } catch (Exception e) {
                    System.out.println("failed.");
                    e.printStackTrace();
                }
            }
        } else {
            System.out.println("No users found in '" + fileName + "'");
        }
        System.exit(0);
    }
    
    private static String getFileName(String[] args) {
        String fileName = null;
        if (args != null) {
            for (int i = 0; (fileName == null) && (i < args.length-1); i++) {
                if ("--file".equals(args[i]) || "--f".equals(args[i])) {
                    fileName = args[i+1];
                }
            }
        }
        if (!StringUtils.isBlank(fileName)) {
            if (!fileName.startsWith("file:///")) {
                fileName = "file:///" + fileName;
            }
        }
        return fileName;
    }

}
